/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.impl.visualization;

import dev.engine_room.flywheel.api.backend.BackendManager;
import dev.engine_room.flywheel.api.backend.Engine;
import dev.engine_room.flywheel.api.backend.RenderContext;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.task.Plan;
import dev.engine_room.flywheel.api.visual.BlockEntityVisual;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visual.Effect;
import dev.engine_room.flywheel.api.visual.TickableVisual;
import dev.engine_room.flywheel.api.visualization.VisualManager;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.api.visualization.VisualizationLevel;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.backend.engine.EngineImpl;
import dev.engine_room.flywheel.impl.FlwConfig;
import dev.engine_room.flywheel.impl.extension.LevelExtension;
import dev.engine_room.flywheel.impl.task.Flag;
import dev.engine_room.flywheel.impl.task.FlwTaskExecutor;
import dev.engine_room.flywheel.impl.task.RaisePlan;
import dev.engine_room.flywheel.impl.task.TaskExecutorImpl;
import dev.engine_room.flywheel.impl.visual.BandedPrimeLimiter;
import dev.engine_room.flywheel.impl.visual.DistanceUpdateLimiterImpl;
import dev.engine_room.flywheel.impl.visual.DynamicVisualContextImpl;
import dev.engine_room.flywheel.impl.visual.NonLimiter;
import dev.engine_room.flywheel.impl.visual.TickableVisualContextImpl;
import dev.engine_room.flywheel.impl.visualization.VisualManagerImpl;
import dev.engine_room.flywheel.impl.visualization.storage.BlockEntityStorage;
import dev.engine_room.flywheel.impl.visualization.storage.EffectStorage;
import dev.engine_room.flywheel.impl.visualization.storage.EntityStorage;
import dev.engine_room.flywheel.lib.task.IfElsePlan;
import dev.engine_room.flywheel.lib.task.MapContextPlan;
import dev.engine_room.flywheel.lib.task.NestedPlan;
import dev.engine_room.flywheel.lib.task.SimplePlan;
import dev.engine_room.flywheel.lib.util.LevelAttached;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import net.minecraft.class_1297;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_3191;
import net.minecraft.class_4076;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.joml.FrustumIntersection;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class VisualizationManagerImpl
implements VisualizationManager {
    private static final LevelAttached<VisualizationManagerImpl> MANAGERS = new LevelAttached<VisualizationManagerImpl>(VisualizationManagerImpl::new, VisualizationManagerImpl::delete);
    private final TaskExecutorImpl taskExecutor;
    private final DistanceUpdateLimiterImpl frameLimiter;
    private final RenderDispatcherImpl renderDispatcher = new RenderDispatcherImpl();
    private final class_1936 level;
    @Nullable
    private LateInit lateInit;
    private final VisualManagerImpl<class_2586, BlockEntityStorage> blockEntities;
    private final VisualManagerImpl<class_1297, EntityStorage> entities;
    private final VisualManagerImpl<Effect, EffectStorage> effects;
    private final Flag frameFlag = new Flag("frame");
    private final Flag tickFlag = new Flag("tick");

    private VisualizationManagerImpl(class_1936 level) {
        this.level = level;
        this.taskExecutor = FlwTaskExecutor.get();
        this.frameLimiter = this.createUpdateLimiter();
        this.blockEntities = new VisualManagerImpl(new BlockEntityStorage());
        this.entities = new VisualManagerImpl(new EntityStorage());
        this.effects = new VisualManagerImpl(new EffectStorage());
        if (level instanceof class_1937) {
            class_1937 l = (class_1937)level;
            LevelExtension.getAllLoadedEntities(l).forEach(this.entities::queueAdd);
        }
    }

    private LateInit lateInit() {
        if (this.lateInit == null) {
            this.lateInit = new LateInit(this.level);
        }
        return this.lateInit;
    }

    private DistanceUpdateLimiterImpl createUpdateLimiter() {
        if (FlwConfig.INSTANCE.limitUpdates()) {
            return new BandedPrimeLimiter();
        }
        return new NonLimiter();
    }

    @Contract(value="null -> false")
    public static boolean supportsVisualization(@Nullable class_1936 level) {
        VisualizationLevel flywheelLevel;
        if (!BackendManager.isBackendOn()) {
            return false;
        }
        if (level == null) {
            return false;
        }
        if (!level.method_8608()) {
            return false;
        }
        if (level instanceof VisualizationLevel && (flywheelLevel = (VisualizationLevel)level).supportsVisualization()) {
            return true;
        }
        return level == class_310.method_1551().field_1687;
    }

    @Nullable
    public static VisualizationManagerImpl get(@Nullable class_1936 level) {
        if (!VisualizationManagerImpl.supportsVisualization(level)) {
            return null;
        }
        return MANAGERS.get(level);
    }

    public static VisualizationManagerImpl getOrThrow(@Nullable class_1936 level) {
        if (!VisualizationManagerImpl.supportsVisualization(level)) {
            throw new IllegalStateException("Cannot retrieve visualization manager when visualization is not supported by level '" + level + "'!");
        }
        return MANAGERS.get(level);
    }

    public static void reset(class_1936 level) {
        MANAGERS.remove(level);
    }

    public static void resetAll() {
        MANAGERS.reset();
    }

    @Override
    public class_2382 renderOrigin() {
        if (this.lateInit == null) {
            return class_2382.field_11176;
        }
        return this.lateInit.engine.renderOrigin();
    }

    @Override
    public VisualManager<class_2586> blockEntities() {
        return this.blockEntities;
    }

    @Override
    public VisualManager<class_1297> entities() {
        return this.entities;
    }

    @Override
    public VisualManager<Effect> effects() {
        return this.effects;
    }

    @Override
    public VisualizationManager.RenderDispatcher renderDispatcher() {
        return this.renderDispatcher;
    }

    public void tick() {
        this.taskExecutor.syncUntil(this.frameFlag::isRaised);
        this.frameFlag.lower();
        this.taskExecutor.syncUntil(this.tickFlag::isRaised);
        this.tickFlag.lower();
        this.lateInit().tickPlan.execute(this.taskExecutor, TickableVisualContextImpl.INSTANCE);
    }

    private void beginFrame(RenderContext context) {
        this.taskExecutor.syncUntil(this.tickFlag::isRaised);
        this.frameFlag.lower();
        this.frameLimiter.tick();
        this.lateInit().framePlan.execute(this.taskExecutor, context);
    }

    private void render(RenderContext context) {
        this.taskExecutor.syncUntil(this.frameFlag::isRaised);
        this.lateInit().engine.render(context);
    }

    private void renderCrumbling(RenderContext context, Long2ObjectMap<SortedSet<class_3191>> destructionProgress) {
        if (destructionProgress.isEmpty()) {
            return;
        }
        ArrayList<Engine.CrumblingBlock> crumblingBlocks = new ArrayList<Engine.CrumblingBlock>();
        for (Long2ObjectMap.Entry entry : destructionProgress.long2ObjectEntrySet()) {
            BlockEntityVisual<?> visual;
            SortedSet set = (SortedSet)entry.getValue();
            if (set == null || set.isEmpty() || (visual = this.blockEntities.getStorage().visualAtPos(entry.getLongKey())) == null) continue;
            ArrayList<Instance> instances = new ArrayList<Instance>();
            visual.collectCrumblingInstances(instance -> {
                if (instance != null) {
                    instances.add((Instance)instance);
                }
            });
            if (instances.isEmpty()) continue;
            class_3191 maxDestruction = (class_3191)set.last();
            crumblingBlocks.add(new CrumblingBlockImpl(maxDestruction.method_13991(), maxDestruction.method_13988(), instances));
        }
        if (!crumblingBlocks.isEmpty()) {
            this.lateInit().engine.renderCrumbling(context, crumblingBlocks);
        }
    }

    public void onLightUpdate(class_4076 sectionPos, class_1944 layer) {
        this.lateInit().engine.onLightUpdate(sectionPos, layer);
        long longPos = sectionPos.method_18694();
        this.blockEntities.onLightUpdate(longPos);
        this.entities.onLightUpdate(longPos);
        this.effects.onLightUpdate(longPos);
    }

    private void delete() {
        this.taskExecutor.syncPoint();
        this.blockEntities.invalidate();
        this.entities.invalidate();
        this.effects.invalidate();
        if (this.lateInit != null) {
            this.lateInit.engine.delete();
        }
    }

    @Nullable
    public EngineImpl getEngineImpl() {
        if (this.lateInit == null) {
            return null;
        }
        Engine engine = this.lateInit.engine;
        if (engine instanceof EngineImpl) {
            EngineImpl engineImpl = (EngineImpl)engine;
            return engineImpl;
        }
        return null;
    }

    private class RenderDispatcherImpl
    implements VisualizationManager.RenderDispatcher {
        private RenderDispatcherImpl() {
        }

        @Override
        public void onStartLevelRender(RenderContext ctx) {
            VisualizationManagerImpl.this.beginFrame(ctx);
        }

        @Override
        public void afterEntities(RenderContext ctx) {
            VisualizationManagerImpl.this.render(ctx);
        }

        @Override
        public void beforeCrumbling(RenderContext ctx, Long2ObjectMap<SortedSet<class_3191>> destructionProgress) {
            VisualizationManagerImpl.this.renderCrumbling(ctx, destructionProgress);
        }
    }

    private class LateInit {
        private final Engine engine;
        private final Plan<RenderContext> framePlan;
        private final Plan<TickableVisual.Context> tickPlan;

        private LateInit(class_1936 level) {
            this.engine = BackendManager.currentBackend().createEngine(level);
            VisualizationContext visualizationContext = this.engine.createVisualizationContext();
            SimplePlan recreate = SimplePlan.of(context -> VisualizationManagerImpl.this.blockEntities.getStorage().recreateAll(visualizationContext, context.partialTick()), context -> VisualizationManagerImpl.this.entities.getStorage().recreateAll(visualizationContext, context.partialTick()), context -> VisualizationManagerImpl.this.effects.getStorage().recreateAll(visualizationContext, context.partialTick()));
            MapContextPlan<RenderContext, DynamicVisual.Context> update = MapContextPlan.map(this::createVisualFrameContext).to(NestedPlan.of(VisualizationManagerImpl.this.blockEntities.framePlan(visualizationContext), VisualizationManagerImpl.this.entities.framePlan(visualizationContext), VisualizationManagerImpl.this.effects.framePlan(visualizationContext)));
            this.framePlan = IfElsePlan.on(ctx -> this.engine.updateRenderOrigin(ctx.camera())).ifTrue(recreate).ifFalse(update).plan().then(SimplePlan.of(() -> {
                if (VisualizationManagerImpl.this.blockEntities.areGpuLightSectionsDirty() || VisualizationManagerImpl.this.entities.areGpuLightSectionsDirty() || VisualizationManagerImpl.this.effects.areGpuLightSectionsDirty()) {
                    LongOpenHashSet out = new LongOpenHashSet();
                    out.addAll((LongCollection)VisualizationManagerImpl.this.blockEntities.gpuLightSections());
                    out.addAll((LongCollection)VisualizationManagerImpl.this.entities.gpuLightSections());
                    out.addAll((LongCollection)VisualizationManagerImpl.this.effects.gpuLightSections());
                    this.engine.lightSections((LongSet)out);
                }
            })).then(this.engine.createFramePlan()).then(RaisePlan.raise(VisualizationManagerImpl.this.frameFlag));
            this.tickPlan = NestedPlan.of(VisualizationManagerImpl.this.blockEntities.tickPlan(visualizationContext), VisualizationManagerImpl.this.entities.tickPlan(visualizationContext), VisualizationManagerImpl.this.effects.tickPlan(visualizationContext)).then(RaisePlan.raise(VisualizationManagerImpl.this.tickFlag));
        }

        private DynamicVisual.Context createVisualFrameContext(RenderContext ctx) {
            class_2382 renderOrigin = this.engine.renderOrigin();
            class_243 cameraPos = ctx.camera().method_19326();
            Matrix4f viewProjection = new Matrix4f(ctx.viewProjection());
            viewProjection.translate((float)((double)renderOrigin.method_10263() - cameraPos.field_1352), (float)((double)renderOrigin.method_10264() - cameraPos.field_1351), (float)((double)renderOrigin.method_10260() - cameraPos.field_1350));
            FrustumIntersection frustum = new FrustumIntersection((Matrix4fc)viewProjection);
            return new DynamicVisualContextImpl(ctx.camera(), frustum, ctx.partialTick(), VisualizationManagerImpl.this.frameLimiter);
        }
    }

    private record CrumblingBlockImpl(class_2338 pos, int progress, List<Instance> instances) implements Engine.CrumblingBlock
    {
    }
}

